var samplePageObj = {
  // 샘플 타이틀
  title: '스프레드 기능',
  subtitle: '엑셀과 유사한 형식의 시트 기능 예제입니다.',
  // 샘플 설명
  desc: '엑셀의 수식을 사용하여 사용자가 자유롭게 문서를 편집하고 저장할 수 있습니다.<br> 셀에 입력시 =sum( 과 같은 함수를 입력하고 드레그하여 선택한 영역에 대한 값을 계산할 수 있습니다',

  // 객체 초기화 구문
  init: {
    Cfg: {
      // 필수항목
      FormulaEditing: 1, // EFormula 사용하기 위한 설정
      FormulaLocal: 0, // 엑셀 파일을 로드할때는 무조건 0으로 설정
      DragEdit: 2, // EFormula 사용시 셀 드래그로 셀값을 Formula에 넣을 수 있도록하는 기능 (필수는 아니지만 필수적으로 넣어야 생산성이 높아짐, Col.FormulaSuggest: 7 도 비슷)
      RoundNumbers: 5, // 계산된 셀의 포맷을 설정된 Format이 있을고 소수점이 있을떄 RoundNumbersDigits의 개수도 볼지 여부
      RoundNumbersDigits: 12,
      // 선택항목
      FormulaResults: 31, // 입력된 Formula의 결과가 잘못되면 메시지로 알려주도록 설정
      FormulaAddParenthesis: 1, // 입력된 Formula의 마지막 )(괄호)가 없어도 자동으로 입력되도록하는 기능
      FormulaTip: 1, // Formula에 대한 툴팁 설정
      FormulaChanges: 0, // Formula의 변화 상태를 저장할지 여부, 1: 참조하는 값이 변경되어 Formula 결과가 달라질때 상태를 변경, 2: 처음에 로드되서 기본값이 계산될때도 상태를 변경
      FormulaType: 7, // Formula 계산 범위 제한
      FormulaCircular: 6, // Formula 반복 적용시 어떻게 처리하는지 방법을 설정 (6번은 일단 허용하고 에러나면 표시하고 알려줌)

    },
    Def: {
      Row: {
        CanFormula: true,
        Spanned: 1,
      },
      Col: {
        FormulaSuggest: 7, // 셀에서 Formula를 입력할때 추천해주는 기능 (필수는 아니지만 필수적으로 넣어야 생산성이 높아짐, Cfg.DragEdit: 2 도 비슷)
        Spanned: 1,
        CanSort: 0
      }
    },
    LeftCols: [
      {
        Header: ' ',
        Type: 'Int',
        Width: 50,
        Align: 'Center',
        Name: 'SEQ'
      }
    ],
    Cols: [
      {
        Header: 'A',
        Type: 'Auto',
        Name: 'A',
        Width: 100
      },
      {
        Header: 'B',
        Type: 'Auto',
        Name: 'B',
        Width: 100
      },
      {
        Header: 'C',
        Type: 'Auto',
        Name: 'C',
        Width: 100
      },
      {
        Header: 'D',
        Type: 'Auto',
        Name: 'D',
        Width: 100
      },
      {
        Header: 'E',
        Type: 'Auto',
        Name: 'E',
        Width: 100
      },
      {
        Header: 'F',
        Type: 'Auto',
        Name: 'F',
        Width: 100
      },
      {
        Header: 'G',
        Type: 'Auto',
        Name: 'G',
        Width: 100
      },
      {
        Header: 'H',
        Type: 'Auto',
        Name: 'H',
        Width: 100
      },
      {
        Header: 'I',
        Type: 'Auto',
        Name: 'I',
        Width: 100
      },
      {
        Header: 'J',
        Type: 'Auto',
        Name: 'J',
        Width: 100
      },
      {
        Header: 'K',
        Type: 'Auto',
        Name: 'K',
        Width: 100
      },
      {
        Header: 'L',
        Type: 'Auto',
        Name: 'L',
        Width: 100
      },
      {
        Header: 'M',
        Type: 'Auto',
        Name: 'M',
        Width: 100
      },
      {
        Header: 'N',
        Type: 'Auto',
        Name: 'N',
        Width: 100
      },
      {
        Header: 'O',
        Type: 'Auto',
        Name: 'O',
        Width: 100
      },
      {
        Header: 'P',
        Type: 'Auto',
        Name: 'P',
        Width: 100
      },
      {
        Header: 'Q',
        Type: 'Auto',
        Name: 'Q',
        Width: 100
      },
      {
        Header: 'R',
        Type: 'Auto',
        Name: 'R',
        Width: 100
      },
      {
        Header: 'S',
        Type: 'Auto',
        Name: 'S',
        Width: 100
      },
      {
        Header: 'T',
        Type: 'Auto',
        Name: 'T',
        Width: 100
      },
      {
        Header: 'U',
        Type: 'Auto',
        Name: 'U',
        Width: 100
      },
      {
        Header: 'V',
        Type: 'Auto',
        Name: 'V',
        Width: 100
      },
      {
        Header: 'W',
        Type: 'Text',
        Name: 'W',
        Width: 100
      },
      {
        Header: 'X',
        Type: 'Auto',
        Name: 'X',
        Width: 100
      },
      {
        Header: 'Y',
        Type: 'Auto',
        Name: 'Y',
        Width: 100
      },
      {
        Header: 'Z',
        Type: 'Auto',
        Name: 'Z',
        Width: 100
      },

    ],

  },

  // 버튼/기능 영역 html (sampleBtn으로 호출하면 action함수로 연결)
  func: '<div></div>',

  // 객체 생성 Html
  objEl: '<div id=\'sheetDiv\' style=\'width:100%;height:100%\'></div>',

  // 시트 하단 영역 html
  footer: '<span></span>',

  // 객체 생성 구문
  create: function () {
    var options = this.init;

    options.Events = this.event;
    IBSheet.create({
      id: 'sheet', // 생성할 시트의 id
      el: 'sheetDiv', // 시트를 생성할 Dom 객체 및 id
      options: options, // 생성될 시트의 속성
      data: this.data // 생성될 시트의 정적데이터
    });
  },

  // 버튼 클릭시 기능 로직
  action: function () {
  },

  // event구문
  event: {
  },

  // style 추가
  internalStyles: 'a{text-decoration:none;color:#4444FF;}',

  // data
  data: [
    {},
    {},
    {
      B: '국가 기술 자격 통계 (2018 근거)',
      BSpan: 10,
      BTextStyle: 3,
      BTextSize: 15,
      BTextColor: '#EEEEEE',
      BColor: '#223399',
      Height: 40
    },
    {},
    {
      B: '종목별',
      BRowSpan: 2,
      C: '연령별',
      CRowSpan: 2,
      D: 2018,
      DSpan: 8,
      DAlign: 'Center',
      BColor: '#DFDFAA',
      CColor: '#DFDFAA',
      DColor: '#EFEFCC',
      TextStyle: 1
    },
    {
      B: '종목별',
      C: '연령별',
      D: '필기접수 (명)',
      E: '필기응시 (명)',
      F: '필기합격 (명)',
      G: '필기합격률 (%)',
      H: '실기접수 (명)',
      I: '실기응시 (명)',
      J: '실기합격 (명)',
      K: '실기합격률 (%)',
      BColor: '#FAFADF',
      TextStyle: 1,
      DColor: '#EFEFCC',
      EColor: '#EFEFCC',
      FColor: '#EFEFCC',
      GColor: '#EFEFCC',
      HColor: '#EFEFCC',
      IColor: '#EFEFCC',
      JColor: '#EFEFCC',
      KColor: '#EFEFCC'
    },
    {
      B: '기술사',
      C: '합계',
      D: 23450,
      E: 19327,
      F: 2056,
      G: 10.6,
      H: 3184,
      I: 3173,
      J: 1919,
      K: 60.5,
      BRowSpan: 12,
      BTextStyle: 1,
      BColor: '#CADBEE',
      CColor: '#EAEBFA',
      CCanEdit: 0
    },
    {
      B: '기술사',
      C: '19세이하',
      D: 1,
      E: 1,
      F: 0,
      G: 0.0,
      H: 0,
      I: 0,
      J: 0,
      K: 0.0,
      CColor: '#EAEBFA',
      CCanEdit: 0
    },
    {
      B: '기술사',
      C: '20~24',
      D: 8,
      E: 1,
      F: 0,
      G: 0.0,
      H: 0,
      I: 0,
      J: 0,
      K: 0.0,
      CColor: '#EAEBFA',
      CCanEdit: 0
    },
    {
      B: '기술사',
      C: '25~29',
      D: 164,
      E: 126,
      F: 8,
      G: 6.4,
      H: 14,
      I: 14,
      J: 7,
      K: 50.0,
      CColor: '#EAEBFA',
      CCanEdit: 0
    },
    {
      B: '기술사',
      C: '30~34',
      D: 1601,
      E: 1329,
      F: 126,
      G: 9.5,
      H: 206,
      I: 204,
      J: 118,
      K: 57.8,
      CColor: '#EAEBFA',
      CCanEdit: 0
    },
    {
      B: '기술사',
      C: '35~39',
      D: 4251,
      E: 3537,
      F: 426,
      G: 12.0,
      H: 671,
      I: 669,
      J: 386,
      K: 57.7,
      CColor: '#EAEBFA',
      CCanEdit: 0
    },
    {
      B: '기술사',
      C: '40~44',
      D: 5404,
      E: 4441,
      F: 541,
      G: 12.2,
      H: 818,
      I: 814,
      J: 514,
      K: 63.1,
      CColor: '#EAEBFA',
      CCanEdit: 0
    },
    {
      B: '기술사',
      C: '45~49',
      D: 5663,
      E: 4575,
      F: 512,
      G: 11.2,
      H: 802,
      I: 801,
      J: 475,
      K: 59.3,
      CColor: '#EAEBFA',
      CCanEdit: 0
    },
    {
      B: '기술사',
      C: '50~54',
      D: 3238,
      E: 2647,
      F: 257,
      G: 9.7,
      H: 393,
      I: 392,
      J: 243,
      K: 62.0,
      CColor: '#EAEBFA',
      CCanEdit: 0
    },
    {
      B: '기술사',
      C: '55~59',
      D: 1905,
      E: 1607,
      F: 124,
      G: 7.7,
      H: 178,
      I: 178,
      J: 114,
      K: 64.0,
      CColor: '#EAEBFA',
      CCanEdit: 0
    },
    {
      B: '기술사',
      C: '60~64',
      D: 899,
      E: 778,
      F: 46,
      G: 5.9,
      H: 79,
      I: 78,
      J: 51,
      K: 65.4,
      CColor: '#EAEBFA',
      CCanEdit: 0
    },
    {
      B: '기술사',
      C: '65세이상',
      D: 316,
      E: 285,
      F: 16,
      G: 5.6,
      H: 23,
      I: 23,
      J: 11,
      K: 47.8,
      CColor: '#EAEBFA',
      CCanEdit: 0
    },
    {
      B: '기능장',
      C: '합계',
      D: 24533,
      E: 21651,
      F: 9903,
      G: 45.7,
      H: 17661,
      I: 16390,
      J: 4862,
      K: 29.7,
      BRowSpan: 12,
      BTextStyle: 1,
      BColor: '#CADBEE',
      CColor: '#EAEBFA',
      CCanEdit: 0
    },
    {
      B: '기능장',
      C: '19세이하',
      D: 2,
      E: 1,
      F: 0,
      G: 0.0,
      H: 2,
      I: 2,
      J: 1,
      K: 50.0,
      CColor: '#EAEBFA',
      CCanEdit: 0
    },
    {
      B: '기능장',
      C: '20~24',
      D: 31,
      E: 25,
      F: 10,
      G: 40.0,
      H: 8,
      I: 7,
      J: 4,
      K: 57.1,
      CColor: '#EAEBFA',
      CCanEdit: 0
    },
    {
      B: '기능장',
      C: '25~29',
      D: 944,
      E: 855,
      F: 454,
      G: 53.1,
      H: 565,
      I: 530,
      J: 237,
      K: 44.7,
      CColor: '#EAEBFA',
      CCanEdit: 0
    },
    {
      B: '기능장',
      C: '30~34',
      D: 2723,
      E: 2388,
      F: 1071,
      G: 44.9,
      H: 1683,
      I: 1576,
      J: 592,
      K: 37.6,
      CColor: '#EAEBFA',
      CCanEdit: 0
    },
    {
      B: '기능장',
      C: '35~39',
      D: 5602,
      E: 4879,
      F: 2133,
      G: 43.7,
      H: 3626,
      I: 3342,
      J: 1157,
      K: 34.6,
      CColor: '#EAEBFA',
      CCanEdit: 0
    },
    {
      B: '기능장',
      C: '40~44',
      D: 5173,
      E: 4531,
      F: 2008,
      G: 44.3,
      H: 3467,
      I: 3185,
      J: 1002,
      K: 31.5,
      CColor: '#EAEBFA',
      CCanEdit: 0
    },
    {
      B: '기능장',
      C: '45~49',
      D: 4904,
      E: 4297,
      F: 2066,
      G: 48.1,
      H: 3860,
      I: 3577,
      J: 1000,
      K: 28.0,
      CColor: '#EAEBFA',
      CCanEdit: 0
    },
    {
      B: '기능장',
      C: '50~54',
      D: 2744,
      E: 2455,
      F: 1218,
      G: 49.6,
      H: 2426,
      I: 2250,
      J: 536,
      K: 23.8,
      CColor: '#EAEBFA',
      CCanEdit: 0
    },
    {
      B: '기능장',
      C: '55~59',
      D: 1571,
      E: 1435,
      F: 617,
      G: 43.0,
      H: 1375,
      I: 1304,
      J: 233,
      K: 17.9,
      CColor: '#EAEBFA',
      CCanEdit: 0
    },
    {
      B: '기능장',
      C: '60~64',
      D: 643,
      E: 600,
      F: 257,
      G: 42.8,
      H: 517,
      I: 492,
      J: 75,
      K: 15.2,
      CColor: '#EAEBFA',
      CCanEdit: 0
    },
    {
      B: '기능장',
      C: '65세이상',
      D: 196,
      E: 185,
      F: 69,
      G: 37.3,
      H: 132,
      I: 125,
      J: 25,
      K: 20.0,
      CColor: '#EAEBFA',
      CCanEdit: 0
    },
    {
      B: '기사',
      C: '합계',
      D: 476572,
      E: 345833,
      F: 135170,
      G: 39.1,
      H: 247097,
      I: 210000,
      J: 89380,
      K: 42.6,
      BRowSpan: 12,
      BTextStyle: 1,
      BColor: '#CADBEE',
      CColor: '#EAEBFA',
      CCanEdit: 0
    },
    {
      B: '기사',
      C: '19세이하',
      D: 21,
      E: 15,
      F: 3,
      G: 20.0,
      H: 3,
      I: 3,
      J: 1,
      K: 33.3,
      CColor: '#EAEBFA',
      CCanEdit: 0
    },
    {
      B: '기사',
      C: '20~24',
      D: 88945,
      E: 76338,
      F: 38680,
      G: 50.7,
      H: 55093,
      I: 50430,
      J: 25408,
      K: 50.4,
      CColor: '#EAEBFA',
      CCanEdit: 0
    },
    {
      B: '기사',
      C: '25~29',
      D: 158195,
      E: 114192,
      F: 46597,
      G: 40.8,
      H: 92606,
      I: 77354,
      J: 31948,
      K: 41.3,
      CColor: '#EAEBFA',
      CCanEdit: 0
    },
    {
      B: '기사',
      C: '30~34',
      D: 69558,
      E: 43906,
      F: 13247,
      G: 30.2,
      H: 27125,
      I: 21309,
      J: 7982,
      K: 37.5,
      CColor: '#EAEBFA',
      CCanEdit: 0
    },
    {
      B: '기사',
      C: '35~39',
      D: 56020,
      E: 35668,
      F: 10343,
      G: 29.0,
      H: 19993,
      I: 15959,
      J: 6365,
      K: 39.9,
      CColor: '#EAEBFA',
      CCanEdit: 0
    },
    {
      B: '기사',
      C: '40~44',
      D: 36699,
      E: 24338,
      F: 7671,
      G: 31.5,
      H: 14926,
      I: 12187,
      J: 4946,
      K: 40.6,
      CColor: '#EAEBFA',
      CCanEdit: 0
    },
    {
      B: '기사',
      C: '45~49',
      D: 28906,
      E: 20531,
      F: 7228,
      G: 35.2,
      H: 14294,
      I: 12012,
      J: 4902,
      K: 40.8,
      CColor: '#EAEBFA',
      CCanEdit: 0
    },
    {
      B: '기사',
      C: '50~54',
      D: 18617,
      E: 14088,
      F: 4984,
      G: 35.4,
      H: 9868,
      I: 8635,
      J: 3292,
      K: 38.1,
      CColor: '#EAEBFA',
      CCanEdit: 0
    },
    {
      B: '기사',
      C: '55~59',
      D: 12335,
      E: 10261,
      F: 3940,
      G: 38.4,
      H: 7856,
      I: 7154,
      J: 2744,
      K: 38.4,
      CColor: '#EAEBFA',
      CCanEdit: 0
    },
    {
      B: '기사',
      C: '60~64',
      D: 5955,
      E: 5300,
      F: 2071,
      G: 39.1,
      H: 4364,
      I: 4046,
      J: 1501,
      K: 37.1,
      CColor: '#EAEBFA',
      CCanEdit: 0
    },
    {
      B: '기사',
      C: '65세이상',
      D: 1321,
      E: 1196,
      F: 406,
      G: 34.0,
      H: 969,
      I: 911,
      J: 291,
      K: 31.9,
      CColor: '#EAEBFA',
      CCanEdit: 0
    },
    {
      B: '산업기사',
      C: '합계',
      D: 274220,
      E: 210814,
      F: 78209,
      G: 37.1,
      H: 119178,
      I: 101949,
      J: 49993,
      K: 49.0,
      BRowSpan: 12,
      BTextStyle: 1,
      BColor: '#CADBEE',
      CColor: '#EAEBFA',
      CCanEdit: 0
    },
    {
      B: '산업기사',
      C: '19세이하',
      D: 2156,
      E: 1880,
      F: 584,
      G: 31.1,
      H: 616,
      I: 582,
      J: 325,
      K: 55.8,
      CColor: '#EAEBFA',
      CCanEdit: 0
    },
    {
      B: '산업기사',
      C: '20~24',
      D: 98713,
      E: 83429,
      F: 33332,
      G: 40.0,
      H: 44921,
      I: 40166,
      J: 21420,
      K: 53.3,
      CColor: '#EAEBFA',
      CCanEdit: 0
    },
    {
      B: '산업기사',
      C: '25~29',
      D: 66296,
      E: 48336,
      F: 19568,
      G: 40.5,
      H: 31320,
      I: 25679,
      J: 12879,
      K: 50.2,
      CColor: '#EAEBFA',
      CCanEdit: 0
    },
    {
      B: '산업기사',
      C: '30~34',
      D: 27265,
      E: 18616,
      F: 6188,
      G: 33.2,
      H: 9867,
      I: 7914,
      J: 3715,
      K: 46.9,
      CColor: '#EAEBFA',
      CCanEdit: 0
    },
    {
      B: '산업기사',
      C: '35~39',
      D: 24337,
      E: 16572,
      F: 4993,
      G: 30.1,
      H: 8019,
      I: 6525,
      J: 2927,
      K: 44.9,
      CColor: '#EAEBFA',
      CCanEdit: 0
    },
    {
      B: '산업기사',
      C: '40~44',
      D: 18234,
      E: 12875,
      F: 4030,
      G: 31.3,
      H: 6876,
      I: 5668,
      J: 2558,
      K: 45.1,
      CColor: '#EAEBFA',
      CCanEdit: 0
    },
    {
      B: '산업기사',
      C: '45~49',
      D: 14773,
      E: 10818,
      F: 3573,
      G: 33.0,
      H: 6351,
      I: 5357,
      J: 2349,
      K: 43.9,
      CColor: '#EAEBFA',
      CCanEdit: 0
    },
    {
      B: '산업기사',
      C: '50~54',
      D: 10163,
      E: 7769,
      F: 2512,
      G: 32.3,
      H: 4515,
      I: 3952,
      J: 1557,
      K: 39.4,
      CColor: '#EAEBFA',
      CCanEdit: 0
    },
    {
      B: '산업기사',
      C: '55~59',
      D: 7456,
      E: 6276,
      F: 2007,
      G: 32.0,
      H: 3803,
      I: 3428,
      J: 1314,
      K: 38.3,
      CColor: '#EAEBFA',
      CCanEdit: 0
    },
    {
      B: '산업기사',
      C: '60~64',
      D: 3929,
      E: 3441,
      F: 1191,
      G: 34.6,
      H: 2344,
      I: 2164,
      J: 806,
      K: 37.3,
      CColor: '#EAEBFA',
      CCanEdit: 0
    },
    {
      B: '산업기사',
      C: '65세이상',
      D: 898,
      E: 802,
      F: 231,
      G: 28.8,
      H: 546,
      I: 514,
      J: 143,
      K: 27.8,
      CColor: '#EAEBFA',
      CCanEdit: 0
    },
    {
      B: '기능사',
      C: '합계',
      D: 1091646,
      E: 916224,
      F: 423269,
      G: 46.2,
      H: 828704,
      I: 752202,
      J: 380198,
      K: 50.5,
      BRowSpan: 13,
      BTextStyle: 1,
      BColor: '#CADBEE',
      CColor: '#EFEDFD',
      CCanEdit: 0
    },
    {
      B: '기능사',
      C: '19세이하',
      D: 327309,
      E: 291937,
      F: 88618,
      G: 30.4,
      H: 233781,
      I: 219763,
      J: 121379,
      K: 55.2,
      CColor: '#EAEBFA',
      CCanEdit: 0
    },
    {
      B: '기능사',
      C: '20~24',
      D: 162228,
      E: 133982,
      F: 66590,
      G: 49.7,
      H: 104576,
      I: 92859,
      J: 43440,
      K: 46.8,
      CColor: '#EAEBFA',
      CCanEdit: 0
    },
    {
      B: '기능사',
      C: '25~29',
      D: 137965,
      E: 108819,
      F: 58999,
      G: 54.2,
      H: 87774,
      I: 76635,
      J: 39396,
      K: 51.4,
      CColor: '#EAEBFA',
      CCanEdit: 0
    },
    {
      B: '기능사',
      C: '30~34',
      D: 95439,
      E: 76192,
      F: 39493,
      G: 51.8,
      H: 62655,
      I: 55177,
      J: 28173,
      K: 51.1,
      CColor: '#EAEBFA',
      CCanEdit: 0
    },
    {
      B: '기능사',
      C: '35~39',
      D: 96697,
      E: 77457,
      F: 41715,
      G: 53.9,
      H: 70917,
      I: 63090,
      J: 32052,
      K: 50.8,
      CColor: '#EAEBFA',
      CCanEdit: 0
    },
    {
      B: '기능사',
      C: '40~44',
      D: 76768,
      E: 61782,
      F: 34778,
      G: 56.3,
      H: 65431,
      I: 58771,
      J: 29764,
      K: 50.6,
      CColor: '#EAEBFA',
      CCanEdit: 0
    },
    {
      B: '기능사',
      C: '45~49',
      D: 71933,
      E: 59003,
      F: 34358,
      G: 58.2,
      H: 70651,
      I: 63887,
      J: 31108,
      K: 48.7,
      CColor: '#EAEBFA',
      CCanEdit: 0
    },
    {
      B: '기능사',
      C: '50~54',
      D: 55045,
      E: 46708,
      F: 26261,
      G: 56.2,
      H: 58041,
      I: 53073,
      J: 24585,
      K: 46.3,
      CColor: '#EAEBFA',
      CCanEdit: 0
    },
    {
      B: '기능사',
      C: '55~59',
      D: 41568,
      E: 36290,
      F: 19618,
      G: 54.1,
      H: 44303,
      I: 40811,
      J: 18171,
      K: 44.5,
      CColor: '#EAEBFA',
      CCanEdit: 0
    },
    {
      B: '기능사',
      C: '60~64',
      D: 21254,
      E: 19115,
      F: 10602,
      G: 55.5,
      H: 24775,
      I: 22865,
      J: 10037,
      K: 43.9,
      CColor: '#EAEBFA',
      CCanEdit: 0
    },
    {
      B: '기능사',
      C: '65세이상',
      D: 5437,
      E: 4937,
      F: 2236,
      G: 45.3,
      H: 5799,
      I: 5270,
      J: 2092,
      K: 39.7,
      CColor: '#EAEBFA',
      CCanEdit: 0
    },
    {
      B: '기능사',
      C: '미상',
      D: 3,
      E: 2,
      F: 1,
      G: 50.0,
      H: 1,
      I: 1,
      J: 1,
      K: 100.0,
      CColor: '#EAEBFA',
      CCanEdit: 0
    },

    {},
    {},
    {},
  ]
};

var sampleBtn = function () {
  var args = Array.prototype.slice.call(arguments, 0);

  samplePageObj.action.apply(null, args);
};
